<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHP Barcode Scanner</title>
    <script src="https://unpkg.com/html5-qrcode"></script>
    <style>
        body { font-family: sans-serif; display: flex; flex-direction: column; align-items: center; }
        #reader { width: 500px; margin-top: 20px; }
        #result { margin-top: 20px; color: green; font-weight: bold; }
    </style>
</head>
<body>

    <h2>Scan Barcode / QR Code</h2>
    <div id="reader"></div>
    <div id="result"></div>

    <script>
        function onScanSuccess(decodedText, decodedResult) {
            // Tampilkan hasil di layar
            document.getElementById('result').innerHTML = "Hasil Scan: " + decodedText;

            // Kirim data ke PHP menggunakan AJAX (Fetch API)
            fetch('simpan.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'barcode=' + encodeURIComponent(decodedText)
            })
            .then(response => response.text())
            .then(data => {
                alert("Data berhasil dikirim ke server: " + data);
            });

            // Hentikan scanner setelah berhasil (Opsional)
            html5QrcodeScanner.clear();
        }

        function onScanFailure(error) {
            // Abaikan error scanning rutin
        }

        let html5QrcodeScanner = new Html5QrcodeScanner(
            "reader", { fps: 10, qrbox: {width: 250, height: 250} }
        );
        html5QrcodeScanner.render(onScanSuccess, onScanFailure);
    </script>
</body>
</html>